/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


#include "DM8127_types.h"
#include "Dm8127_Platform.h"

#ifndef DM8127_LED_H_
#define DM8127_LED_H_

typedef enum
{
	GPIO_BANK_0= 0,
	GPIO_BANK_1,
	GPIO_BANK_2,
	GPIO_BANK_3
}GPIO_BANK_NUM;

//#define WR_MEM_32(addr, data)    *(unsigned int*)(addr) =(unsigned int)(data)
//#define RD_MEM_32(addr) 		 *(unsigned int*)(addr)
//
//#define CTRL_MODULE_BASE_ADDR     0x48140000
//#define    PINCNTL62    (    CTRL_MODULE_BASE_ADDR +    0x08F4    )
//#define    PINCNTL68    (    CTRL_MODULE_BASE_ADDR +    0x090C    )
//#define    PINCNTL110    (    CTRL_MODULE_BASE_ADDR +    0x09B4    )
//#define    PINCNTL15    (    CTRL_MODULE_BASE_ADDR +    0x0838    )
//#define    PINCNTL132    (    CTRL_MODULE_BASE_ADDR +    0x0A0C    )

#define LED_NUM_GP1_7	7
#define LED_NUM_GP1_16  16
#define LED_NUM_GP0_8   8
#define LED_NUM_GP1_30  30
#define LED_NUM_GP1_0   0

#define LED_DELAY (0xFFFF)

/***
 * \brief: LED initialization function.
 *
 * \b \Descr: This routine initialize pin functionality of LED blink test.
 *
 * \param:  VOID
 * \return: VOID
 */
void LED_init
(
	void
);
/***
 * \brief: LED switch ON routine.
 *
 * \b \Descr: This is the switching function for the LED from OFF
 *            state to ON state.
 *
 * \param:  LED_num  LED number
 * \n       bank     BAnk number (GPIO bank)
 *
  *\return: VOID
 */
void LED_on
(
	UINT16 LED_num,
	UINT16 bank
);
/***
 * \brief: LED switch OFF routine.
 *
 * \b \descr: This is the switching function for the LED from ON
 * \n         state to OFF state.
 *
 * \param:  LED_num  LED number
 * \n       bank     BAnk number (GPIO bank)
 *
 * \return: VOID
 */

void LED_off
(
	UINT16 LED_num,
	UINT16 bank
);

#endif /* DM8127_LED_H_ */
